package zen.validation.implementations;

import zen.validation.abstracts.AbstractValidation;

/**
 * Determines if the string value is a valid phone number.
 *
 * RegEx: ^[01]?[- .]?(\\([2-9]\\d{2}\\)|[2-9]\\d{2})[- .]?\\d{3}[- .]?\\d{4}$
 *
 * @author DCano
 *
 */
public class Phone extends AbstractValidation
{
    private final static String PHONE_REGEX = "^[01]?[- .]?(\\([2-9]\\d{2}\\)|[2-9]\\d{2})[- .]?\\d{3}[- .]?\\d{4}$";

    public boolean isValid(final String value)
    {
        return matches(PHONE_REGEX, value);
    }
}
