package zen.validation.implementations;

import zen.validation.abstracts.AbstractValidation;

/**
 * Determines if the string value represents a valid e-mail address.
 *
 * RegEx: ^([0-9a-zA-Z]([-.\\w]*[0-9a-zA-Z])*@([0-9a-zA-Z][-\\w]*[0-9a-zA-Z]\\.)+[a-zA-Z]{2,9})$
 *
 * @author DCano
 *
 */
public class Email extends AbstractValidation
{
    private final static String EMAIL_REGEX = "^([0-9a-zA-Z]([-.\\w]*[0-9a-zA-Z])*@([0-9a-zA-Z][-\\w]*[0-9a-zA-Z]\\.)+[a-zA-Z]{2,9})$";

    public boolean isValid(final String value)
    {
        return matches(EMAIL_REGEX, value);
    }
}
