package zen.validation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import zen.validation.abstracts.AbstractValidation;
import zen.xml.XmlDocument;
import zen.xml.XmlNode;
import zen.logging.interfaces.ILogging;

/**
 * This contains the collection of defined validation rules. This also contains a collection
 * of the object mappings that it knows of from the configuration files.
 *
 * @author DCano
 *
 */
public class ValidationMapping implements Serializable, ILogging
{
	private static final long serialVersionUID = -8296981239058594647L;
	private final static String RULES = "rules";
    private final static String RULE = "rule";
    private final static String MAPPINGS = "mappings";
    private final static String MAPPING = "mapping";

    private final transient Map<String, AbstractValidation> rules = new HashMap<String, AbstractValidation>();
    private final transient Map<String, ObjectMapping> objects = new HashMap<String, ObjectMapping>();

    public ValidationMapping(final String file)
    {
        try
        {
            final XmlDocument document = new XmlDocument(file);
            final XmlNode root = document.getRoot();
            final XmlNode rnodes = root.getChild(RULES);
            final XmlNode mnodes = root.getChild(MAPPINGS);

            MappingUtility.addRules(rules, rnodes.getChildren(RULE));
            MappingUtility.addMappings(objects, mnodes.getChildren(MAPPING));
        }
        catch (Exception exception)
        {
            LOG.error(ValidationMapping.class, exception.toString(), exception);
        }
    }
    
    public AbstractValidation getRule(final String name) throws RuleNotFoundException
    {
        if (rules.containsKey(name))
        {
            return (AbstractValidation) rules.get(name);
        }

        throw new RuleNotFoundException("Rule [" + name + "] Not Found");
    }

    public ObjectMapping getMapping(final String name) throws MappingNotFoundException
    {
        if (objects.containsKey(name))
        {
            return (ObjectMapping) objects.get(name);
        }

        throw new MappingNotFoundException("Mapping for Object [" + name + "] Not Found");
    }
}
