package zen.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Contains the validation definition, which designates a specific property on the Object to 
 * be run through a specific validation rule. This definition also designates the message key
 * or value, and message parameters, if any, to be used if the validation fails. It also 
 * contains a collection of dependent definitions for the same property.
 * 
 * @author DCano
 *
 */
public class ValidationDefinition implements Serializable
{
	private static final long serialVersionUID = 7965543228351898903L;
	private String property;
    private String ruleName;
    private String message;
    private String[] parameters;
    private final transient List<ValidationDefinition> dependencies = new ArrayList<ValidationDefinition>();

    public String getProperty()
    {
        return property;
    }

    public void setProperty(final String property)
    {
        this.property = property;
    }

    public String getRuleName()
    {
        return ruleName;
    }

    public void setRuleName(final String ruleName)
    {
        this.ruleName = ruleName;
    }

    public List<ValidationDefinition> getDependencies()
    {
        return dependencies;
    }

    public void addDependency(final ValidationDefinition definition)
    {
        dependencies.add(definition);
    }

    public String getMessage()
    {
        return message;
    }

    public void setMessage(final String message)
    {
        this.message = message;
    }

    public String[] getParameters()
    {
        return parameters;
    }

    public void setParameters(final String[] parameters)
    {
        this.parameters = parameters;
    }
}
