package zen.validation;

import java.util.ArrayList;
import java.util.List;

import zen.configuration.IConfigurations;
import zen.xml.XmlNode;


/**
 * This class represents the high level collection of specific configurations from the
 * zen-configuration.xml. 
 * 
 * @author DCano
 *
 */
public class Configurations implements IConfigurations
{
    private static final long serialVersionUID = 3021240497828930302L;
    private final static String APPLICATION = "application";
    private final static String NAME = "name";
    private final static String FILE = "file";

    private final transient List<Configuration> configs = new ArrayList<Configuration>();

    public void load(final XmlNode parent)
    {
        for (XmlNode child : parent.getChildren(APPLICATION))
        {
            configs.add(getConfiguration(child));
        }
    }
    
    private Configuration getConfiguration(final XmlNode child)
    {
    	final Configuration configuration = new Configuration();
        configuration.setName(child.getAttribute(NAME));
        configuration.setFile(child.getAttribute(FILE));
        return configuration;
    }

    public List<Configuration> getConfigurations()
    {
        return configs;
    }
}
