package zen.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

import zen.logging.interfaces.ILogging;


public final class SystemUtility implements ILogging
{
	private SystemUtility()
	{
		//Empty constructor
	}
	
	public static Feedback execute(final String command)
	{
		final Feedback feedback = new Feedback();
		
		try
		{
			LOG.info(SystemUtility.class, "#### Command: " + command);
			final Runtime runtime = Runtime.getRuntime();
			final Process process = runtime.exec(command);
			feedback(feedback.getInput(), process.getInputStream());
			feedback(feedback.getError(), process.getErrorStream());
			process.waitFor();
		}
		catch (IOException exception)
		{
			addError(feedback, exception);
		}
		catch (InterruptedException exception)
		{
			addError(feedback, exception);
		}
				
		return feedback;
	}
	
	private static void feedback(final List<String> lines, final InputStream input) throws IOException
	{
		final BufferedReader reader = new BufferedReader(new InputStreamReader(input));
		
		String line = null;
		
		while ((line = reader.readLine()) != null)
		{
			//LOG.debug(SystemUtility.class, line);
			lines.add(line);
		}
			
		reader.close();
	}
	
	private static void addError(final Feedback feedback, final Throwable throwable)
	{
		feedback.getError().add(throwable.toString());
		
		for (StackTraceElement element : throwable.getStackTrace())
		{
			feedback.getError().add("*** " + element.toString());
		}
		
		if (throwable.getCause() != null)
		{
			addError(feedback, throwable.getCause());
		}
	}
}
