package zen.system;

import java.util.ArrayList;
import java.util.List;

import zen.xml.XmlDocument;
import zen.xml.XmlException;

public class Feedback
{
	private List<String> input = new ArrayList<String>();
	private List<String> error = new ArrayList<String>();
	
	public List<String> getInput()
	{
		return input;
	}
	public void setInput(final List<String> input)
	{
		this.input = input;
	}
	public List<String> getError()
	{
		return error;
	}
	public void setError(final List<String> error)
	{
		this.error = error;
	}
	public boolean isError()
	{
		return !error.isEmpty();
	}
	public StringBuffer getInputAsStringBuffer()
	{
		final StringBuffer input = new StringBuffer(100);
		
		for (String line : getInput())
		{
			input.append(line);
		}
		
		return input;
	}
	public XmlDocument getInputAsXmlDocument() throws XmlException
	{
		return new XmlDocument(getInputAsStringBuffer());
	}
}
