package zen.string;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

import zen.utility.Utility;

public final class StringUtility extends Utility
{
	private static final String[] TRUES = 
	{
		"TRUE",
		"T",
		"YES",
		"Y",
		"1"
	};
	
	private static final String[] FALSES = 
	{
		"FALSE",
		"F",
		"NO",
		"N",
		"0"
	};
	
	private StringUtility()
	{
		super();
		
		//Empty constructor
	}
	
    public static String replace(final String string, final String oldValue, final String newValue)
    {
    	final String front = string.substring(0, string.indexOf(oldValue));
    	final String back = string.substring(string.indexOf(oldValue) + oldValue.length(), string.length());
        return (front + newValue + back);
    }
    
	public static boolean getBooleanValue(final String string)
    {
		if (isEmpty(string))
		{
			return false;
		}
		else
		{
        	final String value = string.trim().toUpperCase(Locale.US);

        	for (String tvalue : TRUES)
        	{
        		if (value.equals(tvalue))
        		{
        			return true;
        		}
        	}
        	
        	for (String fvalue : FALSES)
        	{
        		if (value.equals(fvalue))
        		{
        			return false;
        		}
        	}
        	
        	return false;
        }
    }
	
	public static boolean isEmpty(final String string)
    {
        return (string == null || string.trim().isEmpty());
    }
	
	public static String[] split(final String value, final String delim)
    {
		String thisDelim = delim;
		
        if (thisDelim == null)
        {
        	thisDelim = " ";
        }

        if (value != null)
        {
        	final List<String> elements = splitAsList(value, thisDelim);

            if (elements != null)
            {
            	String[] tokens = new String[elements.size()];

                for (int i = 0; i < elements.size(); i++)
                {
                    tokens[i] = (String) elements.get(i);
                }

                return tokens;
            }
        }

        return new String[0];
    }
	
	public static List<String> splitAsList(final String value, final String delim)
	{
		String thisDelim = delim;
		
		if (thisDelim == null)
        {
			thisDelim = " ";
        }

        if (value != null)
        {
        	final List<String> elements = new ArrayList<String>();
        	
            int start = 0;
            int index = -1;

            while ((index = value.indexOf(thisDelim, start)) != -1)
            {
                elements.add(value.substring(start, index).trim());
                start = index + thisDelim.length();
            }

            elements.add(value.substring(start, value.length()).trim());

            return elements;
        }

        return Collections.emptyList();
	}
	
	public static String convertListToDelimitedString(final List<String> list, final String delim)
	{
		final StringBuffer value = new StringBuffer(100);
		
		if (list != null)
		{
			for (String string : list)
			{
				if (!StringUtility.isEmpty(value.toString()))
				{
					value.append(delim);
				}
				
				value.append(string);
			}
		}
		
		return value.toString();
	}
	
	public static String convertArrayToDelimitedString(final String[] list, final String delim)
	{
		final StringBuffer value = new StringBuffer(100);
		
		if (list != null)
		{
			for (String string : list)
			{
				if (!StringUtility.isEmpty(value.toString()))
				{
					value.append(delim);
				}
				
				value.append(string);
			}
		}
		
		return value.toString();
	}
	
	public static String getASCII(final String value)
	{
		final StringBuffer ascii = new StringBuffer(100);
		
		for (int i = 0; i < value.length(); i++)
		{
			ascii.append("[" + ((int) value.charAt(i)) + "]");
		}
		
		return ascii.toString();
	}
}
