package zen.scm.objects;

import zen.business.interfaces.IBusinessObject;
import zen.scm.enums.Change;
import zen.scm.enums.Kind;
import zen.string.StringUtility;

public class ChangeObject implements IBusinessObject
{
	private static final long serialVersionUID = 5483685033287720855L;
	private Kind kind;
	private Change change;
	private String path;
	private String fromPath;
	private Long fromRevision;
	private Boolean modifiedFile;
	private Boolean modifiedProperty;
	
	public Kind getKind()
	{
		return kind;
	}
	public void setKind(final Kind kind)
	{
		this.kind = kind;
	}
	public Change getChange()
	{
		return change;
	}
	public void setChange(final Change change)
	{
		this.change = change;
	}
	public String getPath()
	{
		return path;
	}
	public void setPath(final String path)
	{
		this.path = path;
	}
	public String getFromPath()
	{
		return fromPath;
	}
	public void setFromPath(final String fromPath)
	{
		this.fromPath = fromPath;
	}
	public Long getFromRevision()
	{
		return fromRevision;
	}
	public void setFromRevision(final Long fromRevision)
	{
		this.fromRevision = fromRevision;
	}
	public boolean wasCopied()
	{
		return (!StringUtility.isEmpty(getFromPath()));
	}
	public boolean isModifiedFile()
	{
		if (modifiedFile == null)
		{
			modifiedFile = Boolean.FALSE;
		}
		
		return modifiedFile.booleanValue();
	}
	public void setModifiedFile(final boolean modifiedFile)
	{
		this.modifiedFile = modifiedFile?Boolean.TRUE:Boolean.FALSE;
	}
	public boolean isModifiedProperty()
	{
		if (modifiedProperty == null)
		{
			modifiedProperty = Boolean.FALSE;
		}
		
		return modifiedProperty.booleanValue();
	}
	public void setModifiedProperty(final boolean modifiedProperty)
	{
		this.modifiedProperty = modifiedProperty?Boolean.TRUE:Boolean.FALSE;
	}
	
	public String getTypeOfChange()
	{
		String value = null;
		
		if (isModifiedFile() && isModifiedProperty())
		{
			value = "File and Property";
		}
		else if (isModifiedFile())
		{
			value = "File";
		}
		else if (isModifiedProperty())
		{
			value = "Property";
		}
		else
		{
			value = "N/A";
		}
		
		return value;
	}
}
