package zen.scm.implementations.svn;

import java.util.Calendar;
import java.util.Date;

import zen.date.DateUtility;
import zen.scm.CommandException;
import zen.scm.enums.Change;
import zen.scm.enums.Kind;
import zen.scm.objects.ProfileObject;
import zen.string.StringUtility;
import zen.system.Feedback;
import zen.system.SystemUtility;
import zen.utility.Utility;

public final class SvnUtility extends Utility
{
	private SvnUtility()
	{
		super();
		
		//Empty constructor
	}
	
	public static Kind getKind(final String value)
	{
		Kind kind = null;
		
		if (!StringUtility.isEmpty(value))
		{
			if ("file".equals(value))
			{
				kind =  Kind.FILE;
			}
			else if ("dir".equals(value))
			{
				kind =  Kind.DIRECTORY;
			}	
		}
		
		return kind;
	}
	
	public static Change getChange(final String value)
	{
		Change change = null;
		
		if (!StringUtility.isEmpty(value))
		{
			if ("A".equals(value))
			{
				change = Change.ADDED;	
			}
			else if ("D".equals(value))
			{
				change = Change.DELETED;
			}
			else if ("M".equals(value))
			{
				change = Change.MODIFIED;
			}
			else if ("R".equals(value))
			{
				change = Change.REPLACED;
			}
		}
		
		return change;
	}
	
	public static Date getSVNFormattedDate(final String value)
	{
		Date date = null;
		
		if (!StringUtility.isEmpty(value))
		{
			final int index1 = value.indexOf('T');
			final int index2 = value.indexOf('.');
			
			final StringBuffer buffer = new StringBuffer();
			buffer.append(value.substring(0, index1));
			buffer.append(' ');
			buffer.append(value.substring(index1 + 1, index2));
			
			date = DateUtility.parse("yyyy-MM-dd HH:mm:ss", buffer.toString());
		}
		
		return date;
	}
	
	public static Date getFormattedDate(final String line) throws CommandException
	{
		final String[] elements = StringUtility.split(line.trim(), " ");
		final String datetime = elements[0].trim() + " " + elements[1].trim();
		return DateUtility.parse(SvnConstants.PARSE, datetime);
	}
	
	public static String getDateArguments(final Date date1, final Date date2)
	{
		return "{" + getDate(date1) + "}" + SvnConstants.COLON + "{" + getAdjustedDate(date2) + "}";
	}
	
	public static String getDate(final Date date)
	{
		return DateUtility.format(SvnConstants.FORMAT, date); 
	}
	
	public static String getAdjustedDate(final Date date)
	{
		final Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		calendar.add(Calendar.DATE, 1);
		return DateUtility.format(SvnConstants.FORMAT, calendar.getTime());
	}
	
	public static Feedback runSvnCommand(final ProfileObject profile, final String command)
	{
		final StringBuffer statement = new StringBuffer();
		statement.append(SvnConstants.SVN);
		statement.append(SvnConstants.SPACE);
		statement.append(SvnConstants.USERNAME);
		statement.append(SvnConstants.SPACE);
		statement.append(profile.getUsername());
		statement.append(SvnConstants.SPACE);
		statement.append(SvnConstants.PASSWORD);
		statement.append(SvnConstants.SPACE);
		statement.append(profile.getPassword());
		statement.append(SvnConstants.SPACE);
		statement.append(command);
		return SystemUtility.execute(statement.toString());
	}
	
	public static Feedback getSvnLookCommand(final String command)
	{
		final StringBuffer statement = new StringBuffer();
		statement.append(SvnConstants.SVNLOOK);
		statement.append(SvnConstants.SPACE);
		statement.append(command);
		
		final Feedback feedback = SystemUtility.execute(statement.toString());
			
		if (feedback.isError())
		{
			LOG.error(SvnUtility.class, "svnlook does not work on this computer");	
		}

		return feedback;
	}
	
	public static Feedback getSvnAdminCommand(final String command)
	{
		final StringBuffer statement = new StringBuffer();
		statement.append(SvnConstants.SVNADMIN);
		statement.append(SvnConstants.SPACE);
		statement.append(command);
		
		final Feedback feedback = SystemUtility.execute(statement.toString());
		
		if (feedback.isError())
		{
			LOG.error(SvnUtility.class, "svnadmin does not work on this computer");	
		}
		
		return feedback;
	}
}
