package zen.scm.implementations.svn;

import java.util.ArrayList;
import java.util.List;

import zen.scm.CommandException;
import zen.scm.abstracts.AbstractLockCommand;
import zen.scm.objects.LockObject;
import zen.scm.objects.ProfileObject;
import zen.string.StringUtility;
import zen.system.Feedback;


public class SVNLockCommand extends AbstractLockCommand
{
	private final static String LSLOCKS = "lslocks";
	private final static String RMLOCKS = "rmlocks";
	
	public SVNLockCommand(final ProfileObject profile)
	{
		super(profile);
	}
	
	@Override
	public List<LockObject> list(final String path) throws CommandException
	{
		final StringBuffer command = new StringBuffer(20);
		command.append(LSLOCKS);
		command.append(SvnConstants.SPACE);
		command.append(path);
		
		final Feedback feedback = SvnUtility.getSvnAdminCommand(command.toString());
		final List<LockObject> locks = new ArrayList<LockObject>();
		
		if (feedback.getInput() != null && !feedback.getInput().isEmpty())
		{
			LockObject lock = null;
			StringBuffer message = null;
			
			for (String line : feedback.getInput())
			{
				final int index = line.indexOf(":");
				
				if (line.indexOf("Path:") > -1)
				{
					lock = new LockObject();
					lock.setPath(line.substring(index + 1).trim());
				}
				else if (line.indexOf("UUID Token:") > -1)
				{
					lock.setUniqueId(line.substring(index + 1).trim());
				}
				else if (line.indexOf("Owner:") > -1)
				{
					lock.setOwner(line.substring(index + 1).trim());
				}
				else if (line.indexOf("Created:") > -1)
				{
					lock.setCreated(SvnUtility.getFormattedDate(line.substring(index + 1).trim()));
				}
				else if (line.indexOf("Expires:") > -1)
				{
					LOG.debug(getClass(), "ignoring the expires attribute for now");
				}
				else if (StringUtility.isEmpty(line))
				{
					//Means end of lock record
					lock.setMessage(message.toString());
					locks.add(lock);
					LOG.debug(getClass(), "Path [" + lock.getPath() + "]  Owner [" + lock.getOwner() + "]");
				}
				else if (line.indexOf("Comment") > -1)
				{
					message = new StringBuffer();
				}
				else
				{
					if (message != null)
					{
						message.append(line);	
					}
				}
			}
		}

		return locks;
	}

	@Override
	public List<String> remove(final String path, final List<LockObject> locks) throws CommandException
	{
		final List<String> messages = new ArrayList<String>();
		
		for (LockObject lock : locks)
		{
			messages.addAll(remove(path, lock.getPath()));
		}
		
		return messages;
	}

	@Override
	public List<String> remove(final String path, final String file) throws CommandException
	{
		final StringBuffer command = new StringBuffer(20);
		command.append(RMLOCKS);
		command.append(SvnConstants.SPACE);
		command.append(path);
		command.append(SvnConstants.SPACE);
		command.append(file);
		
		final Feedback feedback = SvnUtility.getSvnAdminCommand(command.toString());

		if (feedback.isError())
		{
			throw new CommandException(getErrorMessage(feedback));
		}
		else
		{
			return feedback.getInput();
		}
	}
}
