package zen.scm.implementations.svn;

import java.util.ArrayList;
import java.util.List;

import zen.scm.CommandException;
import zen.scm.abstracts.AbstractListCommand;
import zen.scm.objects.NodeObject;
import zen.scm.objects.ProfileObject;
import zen.system.Feedback;
import zen.xml.XmlDocument;
import zen.xml.XmlException;
import zen.xml.XmlNode;

public class SVNListCommand extends AbstractListCommand
{
	private final static String LIST_COMMAND = "list --xml";
	private final static String REVISION = "-r";
	private final static String RECURSIVE = "-R";
	
	public SVNListCommand(final ProfileObject profile)
	{
		super(profile);
	}
	
	@Override
	public List<NodeObject> list(final String path, final boolean recursive) throws CommandException
	{
		final StringBuffer command = new StringBuffer(20);
		command.append(getCommand(recursive));
		command.append(SvnConstants.SPACE);
		command.append(path);
		
		final Feedback feedback = SvnUtility.runSvnCommand(getProfile(), command.toString());
				
		if (feedback.isError())
		{
			throw new CommandException(getErrorMessage(feedback));
		}
		else
		{
			return getNodes(feedback);
		}
	}
	
	public List<NodeObject> list(final String path, final Long revision, final boolean recursive) throws CommandException
	{
		final StringBuffer command = new StringBuffer(20);
		command.append(getCommand(recursive));
		command.append(SvnConstants.SPACE);
		command.append(REVISION);
		command.append(SvnConstants.SPACE);
		command.append(revision);
		command.append(SvnConstants.SPACE);
		command.append(path);
		
		final Feedback feedback = SvnUtility.runSvnCommand(getProfile(), command.toString());
				
		if (feedback.isError())
		{
			throw new CommandException(getErrorMessage(feedback));
		}
		else
		{
			return getNodes(feedback);
		}
	}
	
	private String getCommand(final boolean recursive)
	{
		final StringBuffer command = new StringBuffer(20);
		command.append(LIST_COMMAND);
		
		if (recursive)
		{
			command.append(SvnConstants.SPACE);
			command.append(RECURSIVE);
		}
		
		return command.toString();
	}
	
	private List<NodeObject> getNodes(final Feedback feedback) throws CommandException
	{
		try
		{
			final List<NodeObject> nodes = new ArrayList<NodeObject>();
			final XmlDocument document = feedback.getInputAsXmlDocument();
			final XmlNode list = document.getNode("list");
			final String path = list.getAttribute("path");
			final List<XmlNode> entries = list.getChildren("entry");
			
			for (XmlNode entry : entries)
			{
				nodes.add(getNodeObject(entry, path));
			}
			
			return nodes;	
		}
		catch (XmlException exception)
		{
			throw new CommandException(exception);
		}
	}
	
	private NodeObject getNodeObject(final XmlNode entry, final String path)
	{
		final NodeObject node = new NodeObject();
		final String name = entry.getChild("name").getValue();
		//final XmlNode commit = entry.getChild("commit");
		
		node.setKind(SvnUtility.getKind(entry.getAttribute("kind")));
		//node.setName(name);
		node.setPath(path + "/" + name);
		//node.setRevision(Long.valueOf(commit.getAttribute("revision")));
		//node.setAuthor(commit.getChild("author").getValue());
		//node.setTimestamp(SvnUtility.getSVNFormattedDate(commit.getChild("date").getValue()));
		return node;
	}
}
