package zen.scm.implementations.svn;

import zen.scm.CommandException;
import zen.scm.abstracts.AbstractInfoCommand;
import zen.scm.objects.InfoObject;
import zen.scm.objects.ProfileObject;
import zen.system.Feedback;
import zen.xml.XmlDocument;
import zen.xml.XmlException;
import zen.xml.XmlNode;

public class SVNInfoCommand extends AbstractInfoCommand
{
	private final static String INFO = "info --xml";
	private final static String REVISION = "-r";
	
	public SVNInfoCommand(final ProfileObject profile)
	{
		super(profile);
	}

	@Override
	public InfoObject info(final String urlPath, final Long revision) throws CommandException
	{
		final StringBuffer command = new StringBuffer();
		command.append(INFO);
		command.append(SvnConstants.SPACE);
		command.append(REVISION);
		command.append(SvnConstants.SPACE);
		command.append(revision.toString());
		command.append(SvnConstants.SPACE);
		command.append(urlPath);
		
		final Feedback feedback = SvnUtility.runSvnCommand(getProfile(), command.toString());
		
		if (feedback.isError())
		{
			throw new CommandException(getErrorMessage(feedback));
		}
		else
		{
			return getInfoObject(feedback);
		}
	}

	@Override
	public InfoObject info(String urlPath) throws CommandException
	{
		final StringBuffer command = new StringBuffer();
		command.append(INFO);
		command.append(SvnConstants.SPACE);
		command.append(urlPath);
		
		final Feedback feedback = SvnUtility.runSvnCommand(getProfile(), command.toString());
		
		if (feedback.isError())
		{
			throw new CommandException(getErrorMessage(feedback));
		}
		else
		{
			return getInfoObject(feedback);
		}
	}
	
	private InfoObject getInfoObject(final Feedback feedback) throws CommandException
	{
		try
		{
			final XmlDocument document = feedback.getInputAsXmlDocument();	
			final XmlNode root = document.getRoot();
			final XmlNode entry = root.getChild("entry");
			final XmlNode repository = entry.getChild("repository");
			final XmlNode commit = entry.getChild("commit");
			
			final InfoObject info = new InfoObject();
			info.setPath(entry.getChild("url").getValue());
			info.setRepository(repository.getChild("root").getValue());
			info.setRevision(Long.valueOf(commit.getAttribute("revision")));
			info.setAuthor(commit.getChild("author").getValue());
			info.setTimestamp(SvnUtility.getSVNFormattedDate(commit.getChild("date").getValue()));
			return info;
		}
		catch (XmlException exception)
		{
			throw new CommandException(exception);
		}
	}
}
