package zen.scm.implementations.svn;

import zen.scm.abstracts.AbstractCatCommand;
import zen.scm.abstracts.AbstractCheckoutCommand;
import zen.scm.abstracts.AbstractCommandFactory;
import zen.scm.abstracts.AbstractDiffCommand;
import zen.scm.abstracts.AbstractInfoCommand;
import zen.scm.abstracts.AbstractListCommand;
import zen.scm.abstracts.AbstractLockCommand;
import zen.scm.abstracts.AbstractLogCommand;
import zen.scm.objects.ProfileObject;

public class SVNCommandFactory extends AbstractCommandFactory
{
	@Override
	public AbstractCatCommand getContentCommand(final ProfileObject profile)
	{
		return new SVNCatCommand(profile);
	}

	@Override
	public AbstractDiffCommand getDifferenceCommand(final ProfileObject profile)
	{
		return new SVNDiffCommand(profile);
	}

	@Override
	public AbstractListCommand getListCommand(final ProfileObject profile)
	{
		return new SVNListCommand(profile);
	}

	@Override
	public AbstractLockCommand getLockCommand(final ProfileObject profile)
	{
		return new SVNLockCommand(profile);
	}

	@Override
	public AbstractLogCommand getLogCommand(final ProfileObject profile)
	{
		return new SVNLogCommand(profile);
	}

	@Override
	public AbstractCheckoutCommand getCheckoutCommand(ProfileObject profile)
	{
		return new SVNCheckoutCommand(profile);
	}

	@Override
	public AbstractInfoCommand getInfoCommand(ProfileObject profile)
	{
		return new SVNInfoCommand(profile);
	}
}
