package zen.scm.implementations.svn;

import zen.scm.CommandException;
import zen.scm.abstracts.AbstractCheckoutCommand;
import zen.scm.objects.ProfileObject;
import zen.system.Feedback;

public class SVNCheckoutCommand extends AbstractCheckoutCommand
{
	private final static String CHECKOUT = "co";
	private final static String REVISION = "-r";
	
	public SVNCheckoutCommand(ProfileObject profile)
	{
		super(profile);
	}

	@Override
	public Feedback checkout(final String urlPath, final String localPath, final Long revision) throws CommandException
	{
		final StringBuffer command = new StringBuffer();
		command.append(CHECKOUT);
		command.append(SvnConstants.SPACE);
		command.append(REVISION);
		command.append(SvnConstants.SPACE);
		command.append(revision.toString());
		command.append(SvnConstants.SPACE);
		command.append(urlPath);
		command.append(SvnConstants.SPACE);
		command.append(localPath);

		return SvnUtility.runSvnCommand(getProfile(), command.toString());
	}

	@Override
	public Feedback checkout(String urlPath, String localPath) throws CommandException
	{
		final StringBuffer command = new StringBuffer();
		command.append(CHECKOUT);
		command.append(SvnConstants.SPACE);
		command.append(urlPath);
		command.append(SvnConstants.SPACE);
		command.append(localPath);
				
		return SvnUtility.runSvnCommand(getProfile(), command.toString());
	}
}
