package zen.scm.implementations.svn;

import java.util.List;

import zen.scm.CommandException;
import zen.scm.abstracts.AbstractCatCommand;
import zen.scm.objects.ProfileObject;
import zen.system.Feedback;


public class SVNCatCommand extends AbstractCatCommand 
{
	private final static String CAT_COMMAND = "cat";
	private final static String REVISION = "-r";
	
	public SVNCatCommand(final ProfileObject profile)
	{
		super(profile);
	}
	
	@Override
	public List<String> cat(final String path) throws CommandException
	{
		final StringBuffer command = new StringBuffer(20);
		command.append(CAT_COMMAND);
		command.append(SvnConstants.SPACE); 
		command.append(REVISION);
		command.append(SvnConstants.SPACE);
		command.append(SvnConstants.HEAD);
		command.append(SvnConstants.SPACE);
		command.append(path);
		
		final Feedback feedback = SvnUtility.runSvnCommand(getProfile(), command.toString());
		
		if (feedback.isError())
		{
			throw new CommandException(getErrorMessage(feedback));
		}
		else
		{
			return feedback.getInput();
		}
	}

	@Override
	public List<String> cat(final String path, final Long revision) throws CommandException
	{
		final StringBuffer command = new StringBuffer(20);
		command.append(CAT_COMMAND);
		command.append(SvnConstants.SPACE);
		command.append(REVISION);
		command.append(SvnConstants.SPACE);
		command.append(revision);
		command.append(SvnConstants.SPACE);
		command.append(path);
		
		final Feedback feedback = SvnUtility.runSvnCommand(getProfile(), command.toString());
		
		if (feedback.isError())
		{
			throw new CommandException(getErrorMessage(feedback));
		}
		else
		{
			return feedback.getInput();
		}
	}
}
