package zen.scm.abstracts;

import java.util.Date;
import java.util.List;

import zen.scm.CommandException;
import zen.scm.objects.ChangeObject;
import zen.scm.objects.ProfileObject;
import zen.scm.objects.RevisionObject;

public abstract class AbstractLogCommand extends AbstractCommand 
{
	public AbstractLogCommand(final ProfileObject profile)
	{
		super(profile);
	}
	
	public abstract List<RevisionObject> revisions(final String path, final boolean stopOnCopy, final boolean useMergeHistory) throws CommandException;
	public abstract List<RevisionObject> revisions(final String path, final Long revision, final boolean stopOnCopy, final boolean useMergeHistory) throws CommandException;
	public abstract List<RevisionObject> revisions(final String path, final Long fromRevision, final Long toRevision, final boolean stopOnCopy, final boolean useMergeHistory) throws CommandException;
	public abstract List<RevisionObject> revisions(final String path, final Date date, final boolean stopOnCopy, final boolean useMergeHistory) throws CommandException;
	public abstract List<RevisionObject> revisions(final String path, final Date fromDate, final Date toDate, final boolean stopOnCopy, final boolean useMergeHistory) throws CommandException;
	public abstract List<ChangeObject> changes(final RevisionObject revision) throws CommandException;
}
