package zen.scm.abstracts;

import java.util.List;

import zen.scm.CommandException;
import zen.scm.objects.ChangeObject;
import zen.scm.objects.ProfileObject;


public abstract class AbstractDiffCommand extends AbstractCommand
{
	public AbstractDiffCommand(final ProfileObject profile)
	{
		super(profile);
	}
	
	public abstract List<String> diff(final String path1, final String path2) throws CommandException;
	public abstract List<String> diff(final String path1, final Long revision1, final String path2, final Long revision2) throws CommandException;
	public abstract List<String> diff(final String path1, final Long revision1, final Long revision2) throws CommandException;
	public abstract List<ChangeObject> summarize(final String path1, final String path2) throws CommandException;
	public abstract List<ChangeObject> summarize(final String path1, final Long revision1, final String path2, final Long revision2) throws CommandException;
	public abstract List<ChangeObject> summarize(final String path1, final Long revision1, final Long revision2) throws CommandException;
}
