package zen.scm.abstracts;

import zen.logging.interfaces.ILogging;
import zen.scm.objects.ProfileObject;
import zen.system.Feedback;


public abstract class AbstractCommand implements ILogging
{
	private ProfileObject profile;
	
	public AbstractCommand(final ProfileObject profile)
	{
		this.profile = profile;
	}
	
	protected ProfileObject getProfile()
	{
		return profile;
	}

	protected void setProfile(final ProfileObject profile)
	{
		this.profile = profile;
	}

	protected String getErrorMessage(final Feedback feedback)
	{
		final StringBuffer error = new StringBuffer();
		
		for (String line : feedback.getError())
		{
			error.append(line);
			error.append('\n');
		}
		
		return error.toString();
	}
}
