package zen.pdf;

import java.math.BigDecimal;
import java.text.NumberFormat;

import zen.logging.interfaces.ILogging;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.draw.VerticalPositionMark;

public class PDFTable implements ILogging
{
	private static final Font NORMAL_FONT = new Font(Font.FontFamily.TIMES_ROMAN, 12, Font.NORMAL, BaseColor.BLACK);
	private static final Font BOLD_FONT = new Font(Font.FontFamily.TIMES_ROMAN, 12, Font.BOLD, BaseColor.BLACK);
	private final transient PdfPTable table;
	
	protected PDFTable(final PdfPTable pdfPTtable, final float width)
	{
		this.table = pdfPTtable;
		this.table.setTotalWidth(width);
	}
	
	protected PdfPTable getTable()
	{
		return table;
	}
	
	private void setDefaulPadding(final PdfPCell cell)
	{
		cell.setPaddingTop(1);
		cell.setPaddingLeft(5);
		cell.setPaddingBottom(1);
		cell.setPaddingRight(5);
	}
	
	public void addCell(final String text, final Font font)
	{
		final PdfPCell cell = new PdfPCell();
		setDefaulPadding(cell);
		cell.setNoWrap(true);
		cell.setBorder(Rectangle.NO_BORDER);
		cell.addElement(new Chunk(text, font));
		table.addCell(cell);
	}
	
	public void addCell(final String text, final Font font, final int border)
	{
		final PdfPCell cell = new PdfPCell();
		setDefaulPadding(cell);
		cell.setNoWrap(true);
		cell.setBorder(border);
		cell.addElement(new Chunk(text, font));
		table.addCell(cell);
	}
	
	public void addCell(final String text, final Font font, final int colSpan, final int border)
	{
		final PdfPCell cell = new PdfPCell();
		cell.setColspan(colSpan);
		cell.setNoWrap(true);
		setDefaulPadding(cell);
		cell.setBorder(border);
		cell.addElement(new Chunk(text, font));
		table.addCell(cell);
	}
	
	public void addCell(final String text, final Font font, final float padding, final int border)
	{
		final PdfPCell cell = new PdfPCell();
		cell.setNoWrap(true);
		cell.setPadding(padding);
		cell.setBorder(border);
		cell.addElement(new Chunk(text, font));
		table.addCell(cell);
	}

	public void addCell(final String text, final Font font, final int colSpan, final float padding, final int border)
	{
		final PdfPCell cell = new PdfPCell();
		cell.setColspan(colSpan);
		cell.setNoWrap(true);
		cell.setPadding(padding);
		cell.setBorder(border);
		cell.addElement(new Chunk(text, font));
		table.addCell(cell);
	}
	
	public void addCell(final String text, final Font font, final BaseColor backgroundColor)
	{
		final PdfPCell cell = new PdfPCell();
		setDefaulPadding(cell);
		cell.setNoWrap(true);
		cell.setBackgroundColor(backgroundColor);
		cell.setBorder(Rectangle.NO_BORDER);
		cell.addElement(new Chunk(text, font));
		table.addCell(cell);
	}
	
	public void addCell(final String text, final Font font, final BaseColor backgroundColor, final int border)
	{
		final PdfPCell cell = new PdfPCell();
		setDefaulPadding(cell);
		cell.setNoWrap(true);
		cell.setBackgroundColor(backgroundColor);
		cell.setBorder(border);
		cell.addElement(new Chunk(text, font));
		table.addCell(cell);
	}
	
	public void addCell(final String text, final Font font, final BaseColor backgroundColor, final int colSpan, final int border)
	{
		final PdfPCell cell = new PdfPCell();
		setDefaulPadding(cell);
		cell.setNoWrap(true);
		cell.setColspan(colSpan);
		cell.setBackgroundColor(backgroundColor);
		cell.setBorder(border);
		cell.addElement(new Chunk(text, font));
		table.addCell(cell);
	}
	
	public void addCell(final String text, final Font font, final BaseColor backgroundColor, final float padding, final int border)
	{
		final PdfPCell cell = new PdfPCell();
		cell.setBackgroundColor(backgroundColor);
		cell.setNoWrap(true);
		cell.setPadding(padding);
		cell.setBorder(border);
		cell.addElement(new Chunk(text, font));
		table.addCell(cell);
	}

	public void addCell(final String text, final Font font, final BaseColor backgroundColor, final int colSpan, final float padding, final int border)
	{
		final PdfPCell cell = new PdfPCell();
		cell.setBackgroundColor(backgroundColor);
		cell.setNoWrap(true);
		cell.setColspan(colSpan);
		cell.setPadding(padding);
		cell.setBorder(border);
		cell.addElement(new Chunk(text, font));
		table.addCell(cell);
	}
	
	public void addFormatedCell(final String name, final String value, final int tab)
	{
		final PdfPCell cell = new PdfPCell();
		setDefaulPadding(cell);
		cell.setNoWrap(true);
		cell.setBorder(Rectangle.NO_BORDER);
		table.addCell(cell);
		
		final Phrase phrase = new Phrase();
		phrase.add(new Chunk(name, NORMAL_FONT));
		phrase.add(new Chunk(new VerticalPositionMark(), tab));
		phrase.add(new Chunk(value, BOLD_FONT));
		cell.addElement(phrase);
	}
	
	public void addFormatedCell(final String name, final Font nameFont, final String value, final Font valueFont, final int tab)
	{
		final PdfPCell cell = new PdfPCell();
		setDefaulPadding(cell);
		cell.setNoWrap(true);
		cell.setBorder(Rectangle.NO_BORDER);
		table.addCell(cell);
		
		final Phrase phrase = new Phrase();
		phrase.add(new Chunk(name, nameFont));
		phrase.add(new Chunk(new VerticalPositionMark(), tab));
		phrase.add(new Chunk(value, valueFont));
		cell.addElement(phrase);
	}
	
	public void addFormatedCell(final String name, final Font nameFont, final String value, final Font valueFont, final int tab, final int colSpan)
	{
		final PdfPCell cell = new PdfPCell();
		cell.setColspan(colSpan);
		setDefaulPadding(cell);
		cell.setNoWrap(true);
		cell.setBorder(Rectangle.NO_BORDER);
		table.addCell(cell);
		
		final Phrase phrase = new Phrase();
		phrase.add(new Chunk(name, nameFont));
		phrase.add(new Chunk(new VerticalPositionMark(), tab));
		phrase.add(new Chunk(value, valueFont));
		cell.addElement(phrase);
	}
	
	public void addFormatedCell(final String name, final Font nameFont, final String value, final Font valueFont, final int tab, final float padding)
	{
		final PdfPCell cell = new PdfPCell();
		cell.setNoWrap(true);
		cell.setPadding(padding);
		cell.setBorder(Rectangle.NO_BORDER);
		table.addCell(cell);
		
		final Phrase phrase = new Phrase();
		phrase.add(new Chunk(name, nameFont));
		phrase.add(new Chunk(new VerticalPositionMark(), tab));
		phrase.add(new Chunk(value, valueFont));
		cell.addElement(phrase);
	}
	
	public void addFormatedCell(final String name, final Font nameFont, final String value, final Font valueFont, final int tab, final float padding, final int border)
	{
		final PdfPCell cell = new PdfPCell();
		cell.setNoWrap(true);
		cell.setPadding(padding);
		cell.setBorder(border);
		table.addCell(cell);
		
		final Phrase phrase = new Phrase();
		phrase.add(new Chunk(name, nameFont));
		phrase.add(new Chunk(new VerticalPositionMark(), tab));
		phrase.add(new Chunk(value, valueFont));
		cell.addElement(phrase);
	}
	
	public void addFormatedCell(final String name, final Font nameFont, final String value, final Font valueFont, final int tab, final int colSpan, final float padding, final int border)
	{
		final PdfPCell cell = new PdfPCell();
		cell.setNoWrap(true);
		cell.setColspan(colSpan);
		cell.setPadding(padding);
		cell.setBorder(border);
		table.addCell(cell);
		
		final Phrase phrase = new Phrase();
		phrase.add(new Chunk(name, nameFont));
		phrase.add(new Chunk(new VerticalPositionMark(), tab));
		phrase.add(new Chunk(value, valueFont));
		cell.addElement(phrase);
	}
	
	public void addFormatedCell(final String name, final BigDecimal value, final int tab)
	{
		final PdfPCell cell = new PdfPCell();
		setDefaulPadding(cell);
		cell.setNoWrap(true);
		cell.setBorder(Rectangle.NO_BORDER);
		table.addCell(cell);
		
		final Phrase phrase = new Phrase();
		phrase.add(new Chunk(name, NORMAL_FONT));
		phrase.add(new Chunk(new VerticalPositionMark(), tab));
		phrase.add(new Chunk(NumberFormat.getInstance().format(value), BOLD_FONT));
		cell.addElement(phrase);
	}
	
	public void addFormatedCell(final String name, final Font nameFont, final BigDecimal value, final Font valueFont, final int tab)
	{
		final PdfPCell cell = new PdfPCell();
		setDefaulPadding(cell);
		cell.setNoWrap(true);
		cell.setBorder(Rectangle.NO_BORDER);
		table.addCell(cell);
		
		final Phrase phrase = new Phrase();
		phrase.add(new Chunk(name, nameFont));
		phrase.add(new Chunk(new VerticalPositionMark(), tab));
		phrase.add(new Chunk(NumberFormat.getInstance().format(value), valueFont));
		cell.addElement(phrase);
	}
	
	public void addFormatedCell(final String name, final Font nameFont, final BigDecimal value, final Font valueFont, final int tab, final int colSpan)
	{
		final PdfPCell cell = new PdfPCell();
		cell.setColspan(colSpan);
		setDefaulPadding(cell);
		cell.setNoWrap(true);
		cell.setBorder(Rectangle.NO_BORDER);
		table.addCell(cell);
		
		final Phrase phrase = new Phrase();
		phrase.add(new Chunk(name, nameFont));
		phrase.add(new Chunk(new VerticalPositionMark(), tab));
		phrase.add(new Chunk(NumberFormat.getInstance().format(value), valueFont));
		cell.addElement(phrase);
	}
	
	public void addFormatedCell(final String name, final Font nameFont, final BigDecimal value, final Font valueFont, final int tab, final float padding)
	{
		final PdfPCell cell = new PdfPCell();
		cell.setNoWrap(true);
		cell.setPadding(padding);
		cell.setBorder(Rectangle.NO_BORDER);
		table.addCell(cell);
		
		final Phrase phrase = new Phrase();
		phrase.add(new Chunk(name, nameFont));
		phrase.add(new Chunk(new VerticalPositionMark(), tab));
		phrase.add(new Chunk(NumberFormat.getInstance().format(value), valueFont));
		cell.addElement(phrase);
	}
	
	public void addFormatedCell(final String name, final Font nameFont, final BigDecimal value, final Font valueFont, final int tab, final float padding, final int border)
	{
		final PdfPCell cell = new PdfPCell();
		cell.setNoWrap(true);
		cell.setPadding(padding);
		cell.setBorder(border);
		table.addCell(cell);
		
		final Phrase phrase = new Phrase();
		phrase.add(new Chunk(name, nameFont));
		phrase.add(new Chunk(new VerticalPositionMark(), tab));
		phrase.add(new Chunk(NumberFormat.getInstance().format(value), valueFont));
		cell.addElement(phrase);
	}
	
	public void addFormatedCell(final String name, final Font nameFont, final BigDecimal value, final Font valueFont, final int tab, final int colSpan, final float padding, final int border)
	{
		final PdfPCell cell = new PdfPCell();
		cell.setColspan(colSpan);
		cell.setNoWrap(true);
		cell.setPadding(padding);
		cell.setBorder(border);
		table.addCell(cell);
		
		final Phrase phrase = new Phrase();
		phrase.add(new Chunk(name, nameFont));
		phrase.add(new Chunk(new VerticalPositionMark(), tab));
		phrase.add(new Chunk(NumberFormat.getInstance().format(value), valueFont));
		cell.addElement(phrase);
	}
}
