package zen.pdf;

import java.io.IOException;

import zen.classpath.ClasspathUtility;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;

public class PDFHeader
{
	private static final String ENCODING = "UTF-8";
	private transient final PdfContentByte content;
	
	protected PDFHeader(final PdfWriter writer)
	{
		this.content = writer.getDirectContentUnder();
	}
	
	public float getWidth()
	{
		return content.getPdfDocument().getPageSize().getWidth();
	}
	
	public float getHeight()
	{
		return content.getPdfDocument().getPageSize().getHeight();
	}
	
	public void addText(final String text, final int xPosition, final int offsetFromTop, final PDFAlign alignment, final String fontType, final BaseColor fontColor, final float fontSize) throws IOException, DocumentException
	{
		final int yPosition = (int) getHeight() - offsetFromTop;
		
		content.beginText();
		content.setColorFill(fontColor);
		content.setFontAndSize(BaseFont.createFont(fontType, ENCODING, true), fontSize);
		content.showTextAligned(alignment.value(), text, xPosition, yPosition, 0);
		content.endText();
	}
	
	public void addImage(final String imagePath, final float scalePercent, final int xPosition, final int offsetFromTop, final PDFAlign alignment) throws IOException, BadElementException, DocumentException
	{
		final int yPosition = (int) getHeight() - offsetFromTop;
		
		final Image image = Image.getInstance(ClasspathUtility.getUrlPath(imagePath));
		image.scalePercent(scalePercent);
		image.setAbsolutePosition(xPosition, yPosition);
		image.setAlignment(alignment.value());
		content.addImage(image);
	}
	
	public void addImage(final String imagePath, final float scalePercentX, final float scalePercentY, final int xPosition, final int offsetFromTop, final PDFAlign alignment) throws IOException, BadElementException, DocumentException
	{
		final int yPosition = (int) getHeight() - offsetFromTop;
		
		final Image image = Image.getInstance(ClasspathUtility.getUrlPath(imagePath));
		image.scalePercent(scalePercentX, scalePercentY);
		image.setAbsolutePosition(xPosition, yPosition);
		image.setAlignment(alignment.value());
		content.addImage(image);
	}
}
