package zen.pdf;

import java.io.IOException;

import zen.classpath.ClasspathUtility;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;

public class PDFFooter
{
	private static final String ENCODING = "UTF-8";
	private transient final PdfContentByte content;
	
	protected PDFFooter(final PdfWriter writer)
	{
		this.content = writer.getDirectContentUnder();
	}
	
	public float getWidth()
	{
		return content.getPdfDocument().getPageSize().getWidth();
	}
	
	public void addText(final String text, final int xPosition, final int offsetFromBottom, final PDFAlign alignment, final String fontType, final BaseColor fontColor, final float fontSize) throws IOException, DocumentException
	{
		content.beginText();
		content.setColorFill(fontColor);
		content.setFontAndSize(BaseFont.createFont(fontType, ENCODING, true), fontSize);
		content.showTextAligned(alignment.value(), text, xPosition, offsetFromBottom, 0);
		content.endText();
	}
	
	public void addImage(final String imagePath, final float scalePercent, final int xPosition, final int offsetFromBottom, final PDFAlign alignment) throws IOException, BadElementException, DocumentException
	{
		final Image image = Image.getInstance(ClasspathUtility.getUrlPath(imagePath));
		image.scalePercent(scalePercent);
		image.setAbsolutePosition(xPosition, offsetFromBottom);
		image.setAlignment(alignment.value());
		content.addImage(image);
	}
	
	public void addImage(final String imagePath, final float scalePercentX, final float scalePercentY, final int xPosition, final int offsetFromBottom, final PDFAlign alignment) throws IOException, BadElementException, DocumentException
	{
		final Image image = Image.getInstance(ClasspathUtility.getUrlPath(imagePath));
		image.scalePercent(scalePercentX, scalePercentY);
		image.setAbsolutePosition(xPosition, offsetFromBottom);
		image.setAlignment(alignment.value());
		content.addImage(image);
	}
}
