package zen.pdf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

import zen.logging.interfaces.ILogging;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfWriter;

public class PDFDocument implements ILogging
{
	private transient int counter;
	private transient PdfWriter writer;
	private transient Document document;
	
	public PDFDocument(final String path)
	{
		try
		{
			initialize(new FileOutputStream(path));
		}
		catch (FileNotFoundException exception)
		{
			LOG.error(getClass(), exception.toString(), exception);
		}
	}
	
	public PDFDocument(final File file)
	{
		try
		{
			initialize(new FileOutputStream(file));
		}
		catch (FileNotFoundException exception)
		{
			LOG.error(getClass(), exception.toString(), exception);
		}
	}
	
	public PDFPage newPDFPage() throws DocumentException
	{
		counter++;
		
		if (counter > 1)
		{
			document.add(Chunk.NEXTPAGE);	
		}
		
		return new PDFPage(writer, document);
	}
	
	private void initialize(final FileOutputStream stream)
	{
		try
		{
			document = new Document();
			writer = PdfWriter.getInstance(document, stream);
		}
		catch (DocumentException exception)
		{
			LOG.error(getClass(), exception.toString(), exception);
		}
	}
	
	public void open()
	{
        document.open();	
	}
	
	public void close()
	{
        document.close();	
	}
}
