package zen.logging.implementations;

import java.util.logging.Logger;

import zen.logging.interfaces.ILogger;

public class SimpleLogger implements ILogger
{
	private static final long serialVersionUID = 2987839215215300931L;
	private final static transient boolean VERBOSE = true;

    public void initialize()
    {
    	//Empty method
    }

    public void trace(final Class CLASS, final String message)
    {
    	Logger.getLogger(CLASS.getName()).fine("==TRACE: [" + CLASS.getName() + "] " + message);
    }

    public void trace(final Class CLASS, final String message, final Throwable throwable)
    {
    	Logger.getLogger(CLASS.getName()).fine("==TRACE: [" + CLASS.getName() + "] " + message);
        printStackTrace(CLASS, throwable);
    }

    public void info(final Class CLASS, final String message)
    {
    	Logger.getLogger(CLASS.getName()).info("--INFO: [" + CLASS.getName() + "] " + message);
    }

    public void info(final Class CLASS, final String message, final Throwable throwable)
    {
    	Logger.getLogger(CLASS.getName()).info("--INFO: [" + CLASS.getName() + "] " + message);
        printStackTrace(CLASS, throwable);
    }

    public void debug(final Class CLASS, final String message)
    {
    	Logger.getLogger(CLASS.getName()).fine(">>DEBUG: [" + CLASS.getName() + "] " + message);
    }

    public void debug(final Class CLASS, final String message, final Throwable throwable)
    {
    	Logger.getLogger(CLASS.getName()).fine(">>DEBUG: [" + CLASS.getName() + "] " + message);
        printStackTrace(CLASS, throwable);
    }

    public void warn(final Class CLASS, final String message)
    {
    	Logger.getLogger(CLASS.getName()).warning("##WARN: [" + CLASS.getName() + "] " + message);
    }

    public void warn(final Class CLASS, final String message, final Throwable throwable)
    {
    	Logger.getLogger(CLASS.getName()).warning("##WARN: [" + CLASS.getName() + "] " + message);
        printStackTrace(CLASS, throwable);
    }

    public void error(final Class CLASS, final String message)
    {
    	Logger.getLogger(CLASS.getName()).severe("**ERROR: [" + CLASS.getName() + "] " + message);
    }

    public void error(final Class CLASS, final String message, final Throwable throwable)
    {
    	Logger.getLogger(CLASS.getName()).severe("**ERROR: [" + CLASS.getName() + "] " + message);
        printStackTrace(CLASS, throwable);
    }

    public void fatal(final Class CLASS, final String message)
    {
    	Logger.getLogger(CLASS.getName()).severe("!!FATAL: [" + CLASS.getName() + "] " + message);
    }

    public void fatal(final Class CLASS, final String message, final Throwable throwable)
    {
    	Logger.getLogger(CLASS.getName()).severe("!!FATAL: [" + CLASS.getName() + "] " + message);
        printStackTrace(CLASS, throwable);
    }
    
	private void printStackTrace(final Class CLASS, final Throwable throwable)
    {
    	final Logger log = Logger.getLogger(CLASS.getName());
    	
        if (VERBOSE)
        {
        	final StackTraceElement[] elements = throwable.getStackTrace();
        	
        	for (StackTraceElement element : elements)
        	{
        		log.info(element.toString());
        	}
        }
        else
        {
        	log.info("  Exception: " + throwable.toString());
        }
    }
}
