package zen.logging.implementations;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

import zen.logging.interfaces.ILogger;

public class Log4JLogger implements ILogger
{
	private static final long serialVersionUID = 1517523171484009504L;

	public void initialize()
    {
        BasicConfigurator.configure();
    }

    public void trace(final Class CLASS, final String message)
    {
        Logger.getLogger(CLASS).debug(message);
    }

    public void trace(final Class CLASS, final String message, final Throwable throwable)
    {
        Logger.getLogger(CLASS).debug(message, throwable);
    }

    public void info(final Class CLASS, final String message)
    {
        Logger.getLogger(CLASS).info(message);
    }

    public void info(final Class CLASS, final String message, final Throwable throwable)
    {
        Logger.getLogger(CLASS).info(message, throwable);
    }

    public void debug(final Class CLASS, final String message)
    {
        Logger.getLogger(CLASS).debug(message);
    }

    public void debug(final Class CLASS, final String message, final Throwable throwable)
    {
        Logger.getLogger(CLASS).debug(message, throwable);
    }

    public void warn(final Class CLASS, final String message)
    {
        Logger.getLogger(CLASS).warn(message);
    }

    public void warn(final Class CLASS, final String message, final Throwable throwable)
    {
        Logger.getLogger(CLASS).warn(message, throwable);
    }

    public void error(final Class CLASS, final String message)
    {
        Logger.getLogger(CLASS).error(message);
    }

    public void error(final Class CLASS, final String message, final Throwable throwable)
    {
        Logger.getLogger(CLASS).error(message, throwable);
    }

    public void fatal(final Class CLASS, final String message)
    {
        Logger.getLogger(CLASS).fatal(message);
    }

    public void fatal(final Class CLASS, final String message, final Throwable throwable)
    {
        Logger.getLogger(CLASS).fatal(message, throwable);
    }
}
