package zen.jndi;

import java.util.Hashtable;

import javax.naming.InitialContext;

import zen.utility.Utility;

public abstract class JNDIUtility extends Utility
{
	protected JNDIUtility()
	{
		super();
		
		//Empty constructor
	}
	
	public static Object lookup(final String jndiName) throws JNDIException
    {
		try
		{
			final InitialContext icontext = new InitialContext();
	        return icontext.lookup(jndiName);	
		}
		catch (Exception exception)
		{
			throw new JNDIException(exception);
		}
    }

	public static Object lookup(final String jndiName, final Hashtable environment) throws JNDIException
    {
    	try
		{
    		final InitialContext icontext = new InitialContext(environment);
            return icontext.lookup(jndiName);
		}
		catch (Exception exception)
		{
			throw new JNDIException(exception);
		}
    }
}
