package zen.guid;

import java.rmi.dgc.VMID;
import java.util.Locale;

import zen.common.AbstractFactory;

public final class GUIDFactory extends AbstractFactory
{
	private static final long serialVersionUID = 2138911183438275298L;
	private static GUIDFactory instance;
	
	private GUIDFactory()
	{
		super();
		
		//Empty constructor
	}
	
	public static GUIDFactory getInstance()
	{
		if (instance == null)
		{
			instance = new GUIDFactory();
		}
		
		return instance;
	}
	
	public GUID generate()
	{
        final String vmid = new VMID().toString();
        final String guid = buildGUID(vmid.toUpperCase(Locale.US));
        LOG.info(GUIDFactory.class, "GUID: " + guid);
        return new GUID(guid);
	}
	
	private String buildGUID(final String vmid)
    {
		final String converted = vmid.replaceAll(":", "").replaceAll("-", "");
		final StringBuffer formatted = new StringBuffer();
        formatted.append(converted.substring(0, 8));
        formatted.append('-');
        formatted.append(converted.substring(8, 12));
        formatted.append('-');
        formatted.append(converted.substring(12, 16));
        formatted.append('-');
        formatted.append(converted.substring(16, 20));
        formatted.append('-');
        formatted.append(converted.substring(20));

        return formatted.toString();
    }
}
