package zen.guid;

import java.io.Serializable;


public class GUID implements Serializable 
{
	private static final long serialVersionUID = -3759167801318620457L;
	private transient String uniqueId;

    public GUID()
    {
        //Empty constructor
    }
    
    public GUID(final String guid)
    {
    	this.uniqueId = guid;
    }

    public GUID(final GUID guid)
    {
        this.uniqueId = guid.getGUID();
    }

    public String getGUID()
    {
    	initialize();
        return uniqueId;
    }
    
    public void setGUID(final String guid) 
    {
        this.uniqueId = guid;
    }

    public String toString()
    {
    	initialize();
        return uniqueId;
    }

    public boolean equals(final Object object)
    {
    	initialize();
    	final GUID guid = (GUID) object;
        return getGUID().equals(guid.getGUID());
    }
    
    private void initialize()
    {
    	if (uniqueId == null) 
        {
            uniqueId = GUIDFactory.getInstance().generate().getGUID();
        }
    }
}
