package zen.file;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

import zen.classpath.ClasspathUtility;
import zen.utility.Utility;

public final class FileUtility extends Utility
{
	private FileUtility()
	{
		super();
		
		//Empty constructor
	}
	
    public static InputStream getStream(final String file) throws FileException
    {
        try
        {
            return ClasspathUtility.getInputStream(file);
        }
        catch (Exception e)
        {
            throw new FileException("Could not open stream to File [" + file + "]", e);
        }
    }

    public static File getFile(final String file) throws FileException, UnsupportedEncodingException
    {
    	final URL url = ClasspathUtility.getUrlPath(file);

        if (url == null)
        {
        	throw new FileException("File [" + file + "] could not be found on the classpath.");
        }
        else
        {
        	return new File(URLDecoder.decode(url.getPath(), "UTF-8"));
        }
    }

    public static File[] getFiles(final String folder) throws FileException, UnsupportedEncodingException
    {
    	final URL url = ClasspathUtility.getUrlPath(folder);

        if (url == null)
        {
        	throw new FileException("Folder [" + folder + "] could not be found on the classpath.");
        }
        else
        {
        	//TODO Need to find alternative to URLDecoder.decode since it is deprecated.
            return new File(URLDecoder.decode(url.getPath(), "UTF-8")).listFiles();
        }
    }
}
