package zen.ejb;

import java.util.Hashtable;

import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.rmi.PortableRemoteObject;

import zen.jndi.JNDIException;
import zen.jndi.JNDIUtility;

public final class EJBUtility extends JNDIUtility
{
	private EJBUtility()
	{
		super();
		
		//Empty constructor
	}
	
	public static EJBLocalHome getLocalHomeInterface(final String jndiName) throws EJBException
    {
		try
		{
			return (EJBLocalHome) lookup(jndiName);
		}
		catch (JNDIException exception)
		{
			throw new EJBException(exception);
		}
    }
    
	public static EJBHome getHomeInterface(final String jndiName, final Class ejbHome) throws EJBException
    {
    	try
		{
    		final Object reference = lookup(jndiName);
            return (EJBHome) PortableRemoteObject.narrow(reference, ejbHome);
		}
		catch (Exception exception)
		{
			throw new EJBException(exception);
		}
    }
    
	public static EJBHome getHomeInterface(final String jndiName, final Hashtable environment, final Class ejbHome) throws EJBException
    {
    	try
		{
    		final Object reference = lookup(jndiName, environment);
            return (EJBHome) PortableRemoteObject.narrow(reference, ejbHome);
		}
		catch (Exception exception)
		{
			throw new EJBException(exception);
		}
    }
}
