package zen.ejb;

import java.util.HashMap;
import java.util.Map;

import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;

import zen.common.AbstractFactory;
import zen.string.StringUtility;

public final class EJBFactory extends AbstractFactory
{
	private static final long serialVersionUID = 183341009102395179L;
	private static EJBFactory instance;
	private final transient Map<String, Object> homeInterfaces = new HashMap<String, Object>();
	
	private EJBFactory()
	{
		super();
		
		//Empty constructor
	}
	
	public static EJBFactory getInstance()
	{
		if (instance == null)
		{
			instance = new EJBFactory();
		}
		
		return instance;
	}
	
	public EJBHome getHomeInterface(final String jndiName, final Class ejbHome) throws EJBException
	{
		if (StringUtility.isEmpty(jndiName))
		{
			throw new EJBException("JNDI name was null or empty");	
		}
		else
		{
			try
			{
				return getEJBHome(jndiName, ejbHome);
			}
			catch (Exception exception)
			{
				LOG.error(EJBFactory.class, exception.toString(), exception);
				throw new EJBException("An error occured while trying to get or create EJBHome for JNDI [" + jndiName + "]", exception);
			}
		}
	}
	
	private EJBHome getEJBHome(final String jndiName, final Class ejbHome) throws EJBException
	{
		EJBHome home = null;
		
		if (homeInterfaces.containsKey(jndiName))
		{
			home = (EJBHome) homeInterfaces.get(jndiName);
		}
		else
		{
			home = EJBUtility.getHomeInterface(jndiName, ejbHome);
			
			if (home == null)
			{
				throw new EJBException("Could not create EJBHome from JNDI [" + jndiName + "]");
			}
			else
			{
				homeInterfaces.put(jndiName, home);
			}
		}
		
		return home;
	}
	
	public EJBLocalHome getLocalInterface(final String jndiName) throws EJBException
	{
		if (StringUtility.isEmpty(jndiName))
		{
			throw new EJBException("JNDI name was null or empty");
		}
		else
		{
			try
			{
				return getEJBLocalHome(jndiName);
				
			}
			catch (Exception exception)
			{
			    LOG.error(EJBFactory.class, exception.toString(), exception);
				throw new EJBException("An error occured trying to get or create EJBLocalHome for JNDI [" + jndiName + "]", exception);
			}
		}
	}
	
	private EJBLocalHome getEJBLocalHome(final String jndiName) throws EJBException
	{
		EJBLocalHome home = null;
		
		if (homeInterfaces.containsKey(jndiName))
		{
			home = (EJBLocalHome) homeInterfaces.get(jndiName);
		}
		else
		{
			home = EJBUtility.getLocalHomeInterface(jndiName);
			
			if (home == null)
			{
				throw new EJBException("Could not create EJBLocalHome from JNDI [" + jndiName + "]");
			}
			else
			{
				homeInterfaces.put(jndiName, home);
			}
		}
		
		return home;
	}
}
