package zen.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import zen.utility.Utility;

public final class DateUtility extends Utility
{
	private DateUtility()
	{
		super();
		
		//Empty constructor
	}
	
	public static String format(final String pattern, final Date date)
	{
		final SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.US);
		return sdf.format(date);
	}
	
	public static Date parse(final String pattern, final String date)
	{
		try
		{
			final SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.US);
			return sdf.parse(date);	
		}
		catch (ParseException e)
		{
			LOG.error(DateUtility.class, e.toString(), e);
			return null;
		}
	}
	
	public static Date getZeroTimeDate(final Date date)
	{
		final Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		calendar.set(Calendar.HOUR, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		return calendar.getTime();
	}
	
	public static boolean isSameDay(final Date date1, final Date date2)
	{
		final Calendar calendar1 = Calendar.getInstance();
		final Calendar calendar2 = Calendar.getInstance();
		calendar1.setTime(date1);
		calendar2.setTime(date2);
		return isSameDay(calendar1, calendar2);
	}
	
	public static boolean isSameDay(final Calendar date1, final Calendar date2)
	{
		if (date1.get(Calendar.YEAR) != date2.get(Calendar.YEAR))
		{
			return false;
		}
		
		if (date1.get(Calendar.MONTH) != date2.get(Calendar.MONTH))
		{
			return false;
		}
		
		if (date1.get(Calendar.DATE) != date2.get(Calendar.DATE))
		{
			return false;
		}
		
		return true;
	}
}
