package zen.configuration;

import java.util.Iterator;

import org.apache.log4j.Logger;

import zen.xml.XmlDocument;
import zen.xml.XmlException;
import zen.xml.XmlNode;

public final class ConfigurationReader
{
	private ConfigurationReader()
	{
		//Empty constructor
	}
	
	public static IConfigurations loadConfigurations(final Class configurations) throws ConfigurationException
    {
        try
        {
        	final IConfigurations iconfigurations = (IConfigurations) configurations.newInstance();
            loadConfigurations(iconfigurations);
            return iconfigurations;
        }
        catch (IllegalAccessException exception)
        {
            throw new ConfigurationException("Class [" + configurations.getName() + "] could not be accessed.", exception);
        }
        catch (InstantiationException exception)
        {
            throw new ConfigurationException("Class [" + configurations.getName() + "] could not be instantiated.", exception);
        }
        catch (Exception exception)
        {
            throw new ConfigurationException("Some error occured while trying to create an instance of Class [" + configurations.getName() + "]", exception);
        }
    }

	public static void loadConfigurations(final IConfigurations configurations) throws ConfigurationException
    {
        boolean loaded = false;
        final XmlNode sections = getDocument().getRoot().getChild(ConfigurationConstants.LAYERS);
        final Iterator<XmlNode> iterator = sections.getChildren(ConfigurationConstants.LAYER).iterator();

        while (iterator.hasNext())
        {
        	final XmlNode section = (XmlNode) iterator.next();
        	final String type = section.getAttribute(ConfigurationConstants.CONFIGURATION);
        	final String name = section.getAttribute(ConfigurationConstants.NAME);

            if (type.equals(configurations.getClass().getName()))
            {
            	final XmlNode node = getDocument().getRoot().getChild(name);
                configurations.load(node);
                loaded = true;
            }
        }

        if (!loaded)
        {
            throw new ConfigurationException("IConfigurations [" + configurations.getClass().getName() + "] not found as a 'layer' mapping in 'layers'");
        }
    }
    
    private static XmlDocument getDocument() throws ConfigurationException
    {
        XmlDocument document = getDocument("/" + ConfigurationConstants.ZEN_CONFIG);

        if (document == null)
        {
        	document = getDocument(ConfigurationConstants.ZEN_CONFIG);
        }
        
        if (document != null)
        {
        	return document;
        }
        else
        {
        	throw new ConfigurationException("Error reading/loading XmlDocument for Configuration [" + ConfigurationConstants.ZEN_CONFIG + "]");        	
        }
    }
    
    private static XmlDocument getDocument(final String path)
    {
    	try
        {
            return new XmlDocument(path);
        }
        catch (XmlException exception)
        {
        	Logger.getLogger(ConfigurationReader.class.getName()).warn(exception.toString());
        	/*e.printStackTrace(System.out);
        	
        	if (e.getCause() != null)
        	{
        		e.getCause().printStackTrace(System.out);
        	}*/
        }
        
        return null;
    }
}
