package zen.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Message implements Serializable
{
	private static final long serialVersionUID = 7910770466874635008L;
	private String value;
    private List<String> parameters = new ArrayList<String>();

    public Message()
    {
    	//Empty constructor
    }

    public Message(final String value)
    {
        this.value = value;
    }

    public Message(final String value, final String parameter)
    {
    	this.value = value;
    	parameters.add(parameter);
    }

    public Message(final String value, final String[] parameters)
    {
    	this.value = value;
        
        for (String parameter : parameters)
        {
        	this.parameters.add(parameter);
        }
    }

    public Message(final String value, final List<String> parameters)
    {
    	this.value = value;
        this.parameters.addAll(parameters);
    }

    public String getValue()
    {
        return value;
    }

    public void setValue(final String value)
    {
        this.value = value;
    }

    public List<String> getParameters()
    {
        return parameters;
    }

    public void setParameters(final List<String> parameters)
    {
        this.parameters = parameters;
    }

    public void addParameter(final String parameter)
    {
        parameters.add(parameter);
    }

    public void addParameters(final String[] parameters)
    {
        for (int i = 0; parameters != null && i < parameters.length; i++)
        {
            addParameter(parameters[i]);
        }
    }

    public void addParameters(final List<String> parameters)
    {
        for (int i = 0; parameters != null && i < parameters.size(); i++)
        {
            addParameter((String) parameters.get(i));
        }
    }
}
