package zen.common;

import java.util.List;

public class Error extends Message
{
	private static final long serialVersionUID = 9176350249856949448L;
	private Throwable throwable;
	
	public Error()
    {
		super();
		
		//Empty constructor
    }

    public Error(final String value)
    {
        super(value);
    }

    public Error(final String value, final String parameter)
    {
        super(value, parameter);
    }

    public Error(final String value, final String[] parameters)
    {
        super(value, parameters);
    }

    public Error(final String value, final List<String> parameters)
    {
        super(value, parameters);
    }
    
    public Error(final Throwable throwable)
    {
    	super();
    	
    	this.throwable = throwable;
    }

    public Error(final String value, final Throwable throwable)
    {
        super(value);
        this.throwable = throwable;
    }

    public Error(final String value, final String parameter, final Throwable throwable)
    {
        super(value, parameter);
        this.throwable = throwable;
    }

    public Error(final String value, final String[] parameters, final Throwable throwable)
    {
        super(value, parameters);
        this.throwable = throwable;
    }

    public Error(final String value, final List<String> parameters, final Throwable throwable)
    {
        super(value, parameters);
        this.throwable = throwable;
    }

	public Throwable getThrowable()
	{
		return throwable;
	}

	public void setThrowable(final Throwable throwable)
	{
		this.throwable = throwable;
	}
}
