package zen.common;

import java.io.Serializable;

import zen.guid.GUID;
import zen.security.SecurityInfo;

public abstract class AbstractTransport implements Serializable 
{
	private static final long serialVersionUID = -3199568889270491769L;
	private transient GUID guid = new GUID();
    private SecurityInfo securityInfo;

    protected AbstractTransport()
    {
    	//Empty constructor
    }
    
    public GUID getGUID()
    {
        return guid;
    }

    public void setGuid(final GUID guid) 
    {
        this.guid = guid;
    }
    
    public SecurityInfo getSecurityInfo()
    {
        return securityInfo;
    }
    public void setSecurityInfo(final SecurityInfo securityInfo)
    {
        this.securityInfo = securityInfo;
    }
}
