package zen.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractResponse extends AbstractTransport
{
	private static final long serialVersionUID = 2273937954769031184L;
	private final transient List<Message> messages = new ArrayList<Message>();

	protected AbstractResponse()
	{
		super();
		
		//Empty constructor
	}
	
    public void addMessage(final Message message)
    {
        messages.add(message);
    }

    public void addMessages(final AbstractResponse response)
    {
        addMessages(response.getMessages());
    }

    public void addMessages(final List<Message> messages)
    {
        final Iterator<Message> iterator = messages.iterator();

        while (iterator.hasNext())
        {
            addMessage((Message) iterator.next());
        }
    }

    public List<Message> getMessages()
    {
        return messages;
    }

    public boolean hasErrors()
    {
    	boolean flag = false;
    	
        for (int i = 0; i < messages.size(); i++)
        {
        	final Message message = (Message) messages.get(i);

            if (message instanceof Error)
            {
                flag = true;
            }
        }

        return flag;
    }
    
    public List<Message> getErrors()
    {
    	final List<Message> errors = new ArrayList<Message>();
        
        for (int i = 0; i < messages.size(); i++)
        {
        	final Message message = (Message) messages.get(i);

            if (message instanceof Error)
            {
                errors.add(message);
            }
        }
        
        return errors;
    }

    public boolean hasMessages()
    {
        return (!messages.isEmpty());
    }
}
