package zen.chart;

import java.util.List;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;

import zen.utility.Utility;


public final class ChartUtility extends Utility
{
	private ChartUtility()
	{
		super();
		
		//Empty constructor
	}
	
	public static JFreeChart getPieChart(String title, List<PieData> list)
	{
		DefaultPieDataset dataset = new DefaultPieDataset();
		
		for (PieData data : list)
		{
			dataset.setValue(data.getName(), data.getValue());
		}
		
		return ChartFactory.createPieChart(title, dataset, false, false, false);
	}
	
	public static JFreeChart getPieChart(final String title, final DefaultPieDataset dataset)
	{
		return ChartFactory.createPieChart(title, dataset, false, false, false);
	}
	
	public static JFreeChart getLineChart(final String title, final String category, final String value, final DefaultCategoryDataset dataset)
	{
		return ChartFactory.createLineChart(title, category, value, dataset, PlotOrientation.VERTICAL, false, false, false);
	}
}
	
