package zen.cache.implementations;

import java.util.HashMap;
import java.util.Map;

import zen.cache.interfaces.ICacheAdapter;
import zen.logging.interfaces.ILogging;

public class SimpleCacheAdapter implements ICacheAdapter, ILogging
{
    private static final long serialVersionUID = -3354044815168059908L;

    private transient Map<String, Object> cache;

    /**
     * Intializes the HashMap for use.
     */
    public void initialize()
    {
        cache = new HashMap<String, Object>();
    }

    /**
     * Puts the item in the HashMap
     * 
     * @param key String
     * @param object Object
     */
    public void put(final String key, final Object object)
    {
        cache.put(key, object);
    }

    /**
     * Gets the cached item from the HashMap using the key.
     * 
     * @param key String 
     * @return Object
     */
    public Object get(final String key)
    {
        return cache.get(key);
    }
    
    public boolean contains(final String key)
    {
        return cache.containsKey(key);
    }

    /**
     * Removes the item from the HashMap with the key
     * 
     * @param key String
     */
    public void remove(final String key)
    {
        cache.remove(key);
    }

    /**
     * Clears the HashMap
     */
    public void refresh()
    {
        cache.clear();
    }
}
