package zen.cache.implementations;

import zen.cache.interfaces.ICacheAdapter;
import zen.common.AbstractAdapter;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;

public class OSCacheAdapter extends AbstractAdapter implements ICacheAdapter
{
    private transient GeneralCacheAdministrator administrator;

    public void initialize()
    {
        administrator = new GeneralCacheAdministrator();
    }

    public Object get(final String key)
    {
    	Object object = null;
    	
        try
        {
        	object = administrator.getFromCache(key);
        }
        catch (NeedsRefreshException e)
        {
            LOG.warn(OSCacheAdapter.class, "Key [" + key + "] does not exist in the Cache.");
        }

        return object;
    }
    
    public boolean contains(final String key)
    {
    	boolean flag = false;
    	
        try
        {
        	flag = (administrator.getFromCache(key) != null);
        }
        catch (NeedsRefreshException e)
        {
            LOG.warn(OSCacheAdapter.class, "Key [" + key + "] does not exist in the Cache.");
        }
        
        return flag;
    }

    public void put(final String key, final Object object)
    {
        administrator.putInCache(key, object);
    }

    public void remove(final String key)
    {
        administrator.removeEntry(key);
    }

    public void refresh()
    {
        administrator.flushAll();
    }
}
