package zen.cache.implementations;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import zen.cache.CacheConstants;
import zen.cache.interfaces.ICacheAdapter;
import zen.common.AbstractAdapter;

public class EHCacheAdapter extends AbstractAdapter implements ICacheAdapter
{
    private transient CacheManager manager;

    public void initialize()
    {
        manager = new CacheManager();
        manager.addCache(CacheConstants.LOLA);
    }

    public Object get(final String key)
    {
        return manager.getCache(CacheConstants.LOLA).get(key).getValue();
    }
    
    public boolean contains(final String key)
    {
        final Element element = manager.getCache(CacheConstants.LOLA).get(key);
        return (element != null);
    }

    public void put(final String key, final Object object)
    {
        manager.getCache(CacheConstants.LOLA).put(new Element(key, object));
    }

    public void remove(final String key)
    {
        manager.getCache(CacheConstants.LOLA).remove(key);
    }

    public void refresh()
    {
        manager.clearAll();
    }
}
