package zen.business.abstracts;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import zen.business.interfaces.IBusinessObject;
import zen.business.interfaces.IDataObject;

import zen.logging.interfaces.ILogging;


public abstract class AbstractCollectionSynchronizer implements ILogging
{
	protected AbstractBusinessTransformer transformer;
	
	protected abstract String getBusinessObjectID(IBusinessObject businessObject);
	protected abstract String getDataObjectID(IDataObject dataObject);
	protected abstract IDataObject getTransformation(IBusinessObject businessObject, IDataObject dataObject);
	protected abstract void set(IDataObject dataObject, IBusinessObject businessObject);
	
	public List<IDataObject> synchronize(final Set<IDataObject> set, final List<IBusinessObject> list, final IDataObject dataObject)
	{
		final List<IDataObject> deleted = new ArrayList<IDataObject>(0);
		
		try
		{
			if (set != null)
			{
				saveupdate(set, list, dataObject);
				deleted.addAll(remove(set, list));
			}
		}
		catch (Exception ex)
		{
			LOG.error(getClass(), "synchronize: " + ex.toString(), ex);
		}
		
		return deleted;
	}
	
	private void saveupdate(final Set<IDataObject> set, final List<IBusinessObject> list, final IDataObject dataObject)
	{
		try
		{
			if (set != null && list != null)
			{
				for (IBusinessObject business : list)
				{
					boolean isNew = true;

					for (IDataObject data : set)
					{
						if (getDataObjectID(data).equals(getBusinessObjectID(business)))
						{
							set(data, business);
							isNew = false;
							break;
						}
					}
					
					if (isNew)
					{
						final IDataObject newDataObject = getTransformation(business, dataObject);
						
						synchronized(set)
						{
							set.add(newDataObject);	
						}
						
						LOG.debug(getClass(), "#### Adding new IDataObject [" + newDataObject.getClass().getName() + "] ID [" + getDataObjectID(newDataObject) + "]");	
					}
				}
			}
		}
		catch (Exception ex)
		{
			LOG.error(getClass(), "add: " + ex.toString(), ex);
		}
	}
	
	private List<IDataObject> remove(final Set<IDataObject> set, final List<IBusinessObject> list)
	{
		final List<IDataObject> deleted = new ArrayList<IDataObject>(0);
		
		try
		{
			if (set != null && list != null)
			{
				for (IDataObject dataObject : set)
				{
					boolean isDeleted = true;
					
					for (IBusinessObject businessObject : list)
					{
						if (getDataObjectID(dataObject).equals(getBusinessObjectID(businessObject)))
						{
							isDeleted = false;
							break;
						}
					}
					
					if (isDeleted)
					{
						deleted.add(dataObject);
						
						synchronized (set)
						{
							set.remove(dataObject);	
						}
						
						LOG.debug(getClass(), "#### Removing new IDataObject [" + dataObject.getClass().getName() + "] ID [" + getDataObjectID(dataObject) + "]");	
					}
				}
			}
		}
		catch (Exception ex)
		{
			LOG.error(getClass(), "remove: " + ex.toString(), ex);
		}
		
		return deleted;
	}
}
