package zen.business.abstracts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import zen.business.interfaces.IBusinessObject;
import zen.business.interfaces.IDataObject;
import zen.logging.interfaces.ILogging;

public abstract class AbstractBusinessTransformer implements ILogging
{
	public Set getDataObjects(final List<? extends IBusinessObject> businessObjects)
	{
		final Set<IDataObject> dataObjects = new HashSet<IDataObject>(0);
		
		if (businessObjects != null)
		{
			for (IBusinessObject businessObject : businessObjects)
			{
				dataObjects.add(getDataObject(businessObject));
			}
		}
		
		return dataObjects;
	}
	
	public List getBusinessObjects(final Set<? extends IDataObject> dataObjects)
	{
		final List<IBusinessObject> businessObjects = new ArrayList<IBusinessObject>(0);
		
		if (dataObjects != null)
		{
			for (IDataObject dataObject : dataObjects)
			{
				businessObjects.add(getBusinessObject(dataObject));
			}
		}
		
		return businessObjects;
	}
	
	public List getBusinessObjects(final List<? extends IDataObject> dataObjects)
	{
		final List<IBusinessObject> businessObjects = new ArrayList<IBusinessObject>(0);
		
		if (dataObjects != null)
		{
			for (IDataObject dataObject : dataObjects)
			{
				businessObjects.add(getBusinessObject(dataObject));
			}
		}
		
		return businessObjects;
	}
	
	public abstract IDataObject getDataObject(IBusinessObject object);
	public abstract IBusinessObject getBusinessObject(IDataObject object);
}
