package zen.business;

import zen.business.abstracts.AbstractBusinessService;
import zen.business.interfaces.IBusinessConvention;
import zen.classpath.ClasspathUtility;
import zen.logging.interfaces.ILogging;

public class ServiceConvention implements IBusinessConvention, ILogging
{
	/**
	 * Check if Service class exists and does it have correct naming convention and interface
	 */
	public void validate(final ConventionMemento memento)
	{
		try
		{
			if (!memento.getServiceName().endsWith(BusinessConstants.SERVICE))
			{
				memento.addMessage(memento.getServiceName() + " should end with " + BusinessConstants.SERVICE);
			}

			final Class<?> classImpl = Class.forName(memento.getServiceName(), false, Thread.currentThread().getContextClassLoader());

			if (!ClasspathUtility.hasParentClass(classImpl, AbstractBusinessService.class))
			{
				memento.addMessage(memento.getServiceName() + " does not implement " + AbstractBusinessService.class.getName());
			}
		}
		catch (Exception ex)
		{
			memento.addMessage(memento.getServiceName() + " could not be instantiated:\n\t" + ex.toString());
		}
	}
}
