package zen.business;

import zen.business.abstracts.AbstractBusinessResponse;
import zen.classpath.ClasspathUtility;

public class ResponseConvention extends ServiceConvention
{
	/**
	 * Check if Response class exists and does it have correct naming convention and inheritance
	 */
	@Override
	public void validate(final ConventionMemento memento)
	{
		try
		{
			final Class<?> classImpl = Class.forName(memento.getResponseName(), false, Thread.currentThread().getContextClassLoader());

			if (!ClasspathUtility.hasParentClass(classImpl, AbstractBusinessResponse.class))
			{
				memento.addMessage(BusinessConstants.RESPONSE + " does not inherit from "
						+ AbstractBusinessResponse.class.getName());
			}
		}
		catch (Exception ex)
		{
			memento.addMessage(memento.getServiceName()
					+ " does not have a corresponding response object whose name ends with "
					+ BusinessConstants.RESPONSE + ": \n\t" + ex.toString());
		}
	}
}
