package zen.business;

import zen.business.abstracts.AbstractBusinessRequest;
import zen.classpath.ClasspathUtility;

public class RequestConvention extends ServiceConvention
{
	/**
	 * Check if Request class exists and does it have correct naming convention and inheritance
	 */
	@Override
	public void validate(final ConventionMemento memento)
	{
		try
		{
			final Class<?> classImpl = Class.forName(memento.getRequestName(), false, Thread.currentThread().getContextClassLoader());

			if (!ClasspathUtility.hasParentClass(classImpl, AbstractBusinessRequest.class))
			{
				memento.addMessage(BusinessConstants.REQUEST + " does not inherit from "
						+ AbstractBusinessRequest.class.getName());
			}
		}
		catch (Exception ex)
		{
			memento.addMessage(memento.getServiceName()
					+ " does not have a corresponding request object whose name ends with " + BusinessConstants.REQUEST
					+ ":\n\t" + ex.toString());
		}
	}
}
