package zen.business;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import zen.string.StringUtility;

public class ConventionMemento implements Serializable
{
	private static final long serialVersionUID = 7584713663105197464L;
	private String serviceName;
    private String requestName;
    private String responseName;
    
    private final transient List<String> messages = new ArrayList<String>();
    
    public ConventionMemento(final String serviceName)
    {
        if (!StringUtility.isEmpty(serviceName) && serviceName.indexOf(BusinessConstants.SERVICE) > -1)
        {
            final String baseName = serviceName.substring(0, serviceName.indexOf(BusinessConstants.SERVICE));
            
            this.requestName = baseName + BusinessConstants.REQUEST;
            this.responseName = baseName + BusinessConstants.RESPONSE;
            this.serviceName = serviceName;    
        }
    }
    public String getServiceName()
    {
        return serviceName;
    }
    public void setServiceName(final String serviceName)
    {
        this.serviceName = serviceName;
    }
    public String getRequestName()
    {
        return requestName;
    }
    public void setRequestName(final String requestName)
    {
        this.requestName = requestName;
    }
    public String getResponseName()
    {
        return responseName;
    }
    public void setResponseName(final String responseName)
    {
        this.responseName = responseName;
    }
    public List<String> getMessages()
    {
        return messages;
    }
    public void addMessage(final String message)
    {
        messages.add(message);
    }
}
