package zen.business;

import java.util.ArrayList;
import java.util.List;

import zen.configuration.IConfigurations;
import zen.logging.interfaces.ILogging;
import zen.xml.XmlNode;

public class Configurations implements IConfigurations, ILogging
{
	private static final long serialVersionUID = -4243702089297511792L;
	private final transient List<String> conventions = new ArrayList<String>();
	private final transient List<String> services = new ArrayList<String>();

	public void load(final XmlNode parent)
	{
		getConventions(parent);
		getServices(parent);
	}
	
	private void getConventions(final XmlNode parent)
	{
		final XmlNode child = parent.getChild(BusinessConstants.TAG_CONVENTIONS);

		if (child == null)
		{
			LOG.debug(this.getClass(), "zen.xml contains no " + BusinessConstants.TAG_CONVENTIONS + " tag.");
		}
		else
		{
			getPackages(this.conventions, child);
			validate(this.conventions, BusinessConstants.TAG_CONVENTIONS);
		}
	}
	
	private void getServices(final XmlNode parent)
	{
		final XmlNode child = parent.getChild(BusinessConstants.TAG_SERVICES);

		if (child == null)
		{
			LOG.debug(this.getClass(), "zen.xml contains no " + BusinessConstants.TAG_CONVENTIONS + " tag.");
		}
		else
		{
			getPackages(this.services, child);
			validate(this.services, BusinessConstants.TAG_SERVICES);
		}
	}
	
	private void validate(final List<String> list, final String TAG)
	{
		if (list == null || list.isEmpty())
		{
			LOG.warn(this.getClass(), "zen.xml has a <" + TAG + "> tag with no valid <" + BusinessConstants.TAG_PACKAGE + "> tags.");
		}
	}
	
	private void getPackages(final List<String> list, final XmlNode child)
	{
		final List<XmlNode> packages = child.getChildren(BusinessConstants.TAG_PACKAGE);

		if (packages != null && !packages.isEmpty())
		{
			for (XmlNode grandchild : packages)
			{
				list.add(grandchild.getValue());
			}
		}
	}

	public List<String> getConventions()
	{
		return this.conventions;
	}

	public List<String> getServices()
	{
		return this.services;
	}
}
