/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import net.sf.xsltmp.XsltGeneratorConstants;
import net.sf.xsltmp.util.DefaultURIResolver;
import net.sf.xsltmp.util.EncodingUtils;
import net.sf.xsltmp.util.TimestampUtils;
import net.sf.xsltmp.util.UnArchiverHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XsltGeneratorBase
extends AbstractMojo
implements XsltGeneratorConstants {
    protected ArchiverManager archiverManager;
    private MavenProject project;
    private BuildContext buildContext;
    private String xslTemplate;
    private Map<String, Object> parameters;
    private boolean force;
    private String sourceEncoding;
    private String filter;
    private Map<String, Object> filterParameters;
    private Transformer transformer = null;
    private File xslFile = null;
    protected DefaultURIResolver resolver = null;
    private UnArchiverHelper helper = null;
    private File timestamp = null;
    private static final EncodingUtils ENCODING_UTILS = new EncodingUtils();

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public ArchiverManager getArchiverManager() {
        return this.archiverManager;
    }

    public void setArchiverManager(ArchiverManager archiverManager) {
        this.archiverManager = archiverManager;
    }

    public String getXslTemplate() {
        return this.xslTemplate;
    }

    public void setXslTemplate(String xslTemplate) {
        this.xslTemplate = xslTemplate;
    }

    public Map<String, Object> getParameters() {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, Object>();
        }
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public boolean getForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public String getSourceEncoding() {
        this.sourceEncoding = ENCODING_UTILS.defaultByPlatformEncoding(this.sourceEncoding, this.getLog());
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Map<String, Object> getFilterParameters() {
        return this.filterParameters;
    }

    public void setFilterParameters(Map<String, Object> filterParameters) {
        this.filterParameters = filterParameters;
    }

    public Transformer getTransformer() throws MojoFailureException {
        if (null == this.transformer) {
            this.createTransformer();
        }
        return this.transformer;
    }

    public DefaultURIResolver getResolver() {
        if (null == this.resolver) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Setting up DefaultURIResolver: sourceEncoding=" + this.getSourceEncoding() + ", filter=" + this.getFilter() + ", filterParameters=" + this.getFilterParameters()));
            }
            this.resolver = new DefaultURIResolver(this.getLog(), this.getProject(), this.getHelper(), this.getSourceEncoding(), this.getFilter(), this.getFilterParameters());
        }
        return this.resolver;
    }

    public UnArchiverHelper getHelper() {
        if (null == this.helper) {
            this.helper = new UnArchiverHelper(this.getLog(), this.getProject(), this.getArchiverManager(), "xslt-generator-maven-plugin/extracts");
        }
        return this.helper;
    }

    public File getXslFile() {
        if (null == this.xslFile) {
            this.xslFile = this.getResolver().resolve(this.getXslTemplate());
        }
        return this.xslFile;
    }

    public File getTimestamp() {
        if (null == this.timestamp) {
            this.timestamp = new TimestampUtils(this.project).getTimestampFile();
        }
        return this.timestamp;
    }

    private void createTransformer() throws MojoFailureException {
        this.getLog().debug((CharSequence)"Creating transformer.");
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setURIResolver(this.getResolver());
        try {
            this.transformer = factory.newTransformer(this.getResolver().resolveAsSource(this.getXslTemplate()));
        }
        catch (TransformerConfigurationException tce) {
            tce.printStackTrace();
            throw new MojoFailureException("Cannot process template file: " + this.getXslTemplate(), (Throwable)tce);
        }
        this.applyParameters();
    }

    private void applyParameters() throws MojoFailureException {
        this.getLog().debug((CharSequence)"Applying parameters.");
        if (this.getParameters() != null) {
            Set<String> keys = this.getParameters().keySet();
            for (String key : keys) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Setting parameter: key=" + key + " value=" + this.getParameters().get(key)));
                }
                this.getTransformer().setParameter(key, this.getParameters().get(key));
            }
            if (this.getParameters().isEmpty()) {
                this.getLog().debug((CharSequence)"No parameters to set.");
            }
        }
    }

    protected boolean verifyXsltFileExist() {
        if (!this.getXslFile().exists()) {
            this.getLog().warn((CharSequence)("Generation not performed, XSL file was not found: " + this.getXslTemplate()));
            return false;
        }
        return true;
    }

    protected String getLogPrefix() {
        return this.getMojoName() + ": " + this.getXslTemplate();
    }

    protected boolean hasChanged(File file) {
        if (this.getForce()) {
            return true;
        }
        return file.lastModified() > this.getTimestamp().lastModified();
    }

    protected abstract String getMojoName();
}

