/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp;

import java.io.File;
import java.util.Arrays;
import net.sf.xsltmp.SrcDirURIResolver;
import net.sf.xsltmp.XsltGeneratorBase;
import net.sf.xsltmp.util.DefaultURIResolver;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public abstract class FromManyBase
extends XsltGeneratorBase {
    private File srcDir;
    private String srcIncludes;
    private String srcExcludes;

    public File getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public String getSrcIncludes() {
        return this.srcIncludes;
    }

    public void setSrcIncludes(String srcIncludes) {
        this.srcIncludes = srcIncludes;
    }

    public String getSrcExcludes() {
        return this.srcExcludes;
    }

    public void setSrcExcludes(String srcExcludes) {
        this.srcExcludes = srcExcludes;
    }

    protected boolean verifySrcDirExist() {
        if (!this.getSrcDir().exists()) {
            this.getLog().warn((CharSequence)("Generation not performed, source directory does not exist: " + this.getSrcDir()));
            return false;
        }
        return true;
    }

    protected String[] getSourceFiles() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.getSrcDir());
        scanner.setIncludes(StringUtils.split((String)this.getSrcIncludes(), (String)", "));
        if (this.getSrcExcludes() != null) {
            scanner.setExcludes(StringUtils.split((String)this.getSrcExcludes(), (String)", "));
        }
        scanner.scan();
        Object[] sourceFiles = scanner.getIncludedFiles();
        Arrays.sort(sourceFiles);
        if (0 == sourceFiles.length) {
            this.getLog().info((CharSequence)"No source files to process.");
        }
        return sourceFiles;
    }

    protected File getSourceFile(String sourceFileName) {
        return new File(this.getSrcDir(), sourceFileName);
    }

    protected void ensureDestFileDirExists(File destFile) throws MojoFailureException {
        boolean dirCreationResult;
        File parentDestFile = destFile.getParentFile();
        if (!parentDestFile.exists() && !(dirCreationResult = parentDestFile.mkdirs())) {
            throw new MojoFailureException("Destination directory structure could not be initialised. Failed to create directory: " + parentDestFile.getAbsolutePath());
        }
    }

    protected boolean shouldStopM2eBuild() {
        boolean shouldStop;
        boolean hasProject = this.getProject() != null;
        boolean isIncrementalBuild = this.getBuildContext().isIncremental();
        boolean nothingChanged = !this.getBuildContext().hasDelta(this.getProject().getBasedir());
        boolean bl = shouldStop = hasProject && isIncrementalBuild && nothingChanged;
        if (shouldStop) {
            this.getLog().info((CharSequence)"Stopping m2e configuration build, nothing has changed.");
        }
        return shouldStop;
    }

    protected void logExecution(File srcFile) {
        this.getLog().info((CharSequence)("Running " + this.getLogPrefix() + " on srcFile: " + srcFile));
    }

    public DefaultURIResolver getResolver() {
        if (null == this.resolver) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Setting up SrcDirURIResolver: srcDir=" + this.getSrcDir() + ", sourceEncoding=" + this.getSourceEncoding() + ", filter=" + this.getFilter() + ", filterParameters=" + this.getFilterParameters()));
            }
            this.resolver = new SrcDirURIResolver(this.getSrcDir(), this.getLog(), this.getProject(), this.getHelper(), this.getSourceEncoding(), this.getFilter(), this.getFilterParameters());
        }
        return this.resolver;
    }
}

